
#import <Foundation/Foundation.h>

typedef enum _MCPPrimaryKeyState {
	MCPPrimaryKeyNotDetermined 	= 0,
	MCPPrimaryKeyNotSet			= 1,
	MCPPartialPrimaryKey		= 2,
	MCPValidPrimaryKey			= 3
} MCPPrimaryKeyState;


/*
An object is unlocked by default. An editor locks it before editing and then unlock it after it's done. In the event of deferred saving, the lock state of an editing object should be set to unlock after a save is done. In the event save is called while the editing still have the object selected, then it shouldn't unlocked after saving.

*/
typedef enum _MCPObjectLockState {
	MCPUnLocked 			= 0,
	MCPLocked				= 1,
	MCPUnlockAfterSave		= 2
} MCPObjectLockState;


typedef enum _MCPDeleteRule {
	MCPDeleteRuleNullify 	= 0,
	MCPDeleteRuleCascade	= 1,
	MCPDeleteRuleDeny		= 2,
	MCPDeleteRuleNoAction	= 3
} MCPDeleteRule;

typedef enum _MCPSupportedPlatforms {
    MCPSupportedPlatformsAll          = 0,
    MCPSupportedPlatformsDesktopOnly = 1,
    MCPSupportedPlatformsTouchOnly   = 2,
    MCPSupportedPlatformsCustomOnly  = 3,
    MCPSupportedPlatformsWebOnly   = 4
} MCPSupportedPlatforms;


typedef enum _MCPDatabaseQueryType {
	kMCPDatabaseSelectQueryType = 0,
	kMCPDatabaseCountQueryType,
	kMCPDatabaseRelationshipFaultQueryType	
} MCPDatabaseQueryType;


extern NSString *MCPMoreThanOneException;
extern NSString *MCPValidationException;


// Sent from the object context when an object has been added or removed from another object via a keyed relationship (as defined in the entity and model) -- Useful for updating list views ...
// The notification's object is the objectContext, the userInfo contains the keys described below
extern NSString *MCPWillAddRelatedObjectNotification;
extern NSString *MCPDidAddRelatedObjectNotification;
extern NSString *MCPWillRemoveRelatedObjectNotification;
extern NSString *MCPDidRemoveRelatedObjectNotification;

// Related Object Changed Notification Keys
extern NSString *MCPDocumentKey;
extern NSString *MCPParentObject;
extern NSString *MCPRelatedObject;
extern NSString *MCPRelationshipKey;

extern NSString *MCPWillChangeDatabaseConnectionNotification;
extern NSString *MCPDidChangeDatabaseConnectionNotification;

// Controls whether we are putting objects in the defaultInstance of the MCObjectCache when we initWithCoder: them.
// Set to 1 to have this behaviour turned on! (off by default!!)
extern int MCPObjectInitObjectsIntoObjectCache;
